import numpy as np
from torch.utils.data import Dataset, DataLoader
import torch
import os
from tqdm import tqdm

device = "cuda" if torch.cuda.is_available() else "cpu"


from sklearn.linear_model import LogisticRegression
    

class SHHS_DataLoader(Dataset):
    
    def __init__(self, csv, num_strips, dir = "", l = 10,  fs = 100, std_s1=0.12636206, std_s2=0.14737946):
        self.csv = np.array(csv)

        self.std_s1 = std_s1
        self.std_s2 = std_s2

        self.num_strips = num_strips
        self.l = l
        self.fs = fs
        self.input_size = self.l * self.fs

        self.dir = dir



    def __len__(self):
        return self.csv.shape[0]

    def __getitem__(self, ix):
              
        pat_path, strip, tmp_study = self.csv[ix, :]
        strip_path = os.path.join(pat_path, str(strip))

        tmp_study = int(tmp_study)
        tmp_std = self.std_s1 if tmp_study == 1 else self.std_s2
        tmp_strip = np.load(strip_path)
 
        ini_idx = np.random.randint(0,  tmp_strip.shape[0] - self.l * self.fs)       
        x1 = tmp_strip[ini_idx : ini_idx + self.l * self.fs]

        x1 = x1 / tmp_std
        
        return torch.tensor(x1).float().to(device)

